/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_1535;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import subaraki.paintings.Paintings;
import subaraki.paintings.gui.IPaintingGUI;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.utils.CommonConfig;

public class CommonPaintingScreen
extends class_437
implements IPaintingGUI {
    public static final int START_X = 10;
    public static final int START_Y = 30;
    public static final int GAP = 5;
    private final int entityID;
    private final class_4185 defaultButton = new class_4185(0, 0, 0, 0, (class_2561)new class_2585("default"), button -> {});
    private final class_1535[] types;
    private int scrollBarScroll = 0;

    public CommonPaintingScreen(class_1535[] types, int entityID) {
        super((class_2561)new class_2588("select.a.painting"));
        this.types = types;
        this.entityID = entityID;
    }

    protected void method_25426() {
        super.method_25426();
        this.addButtons();
        this.scrollBarScroll = 0;
    }

    private void addButtons() {
        int END_X = this.field_22789 - 30;
        int prevHeight = this.types[0].method_6943();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (class_1535 motive : this.types) {
            if (posx + motive.method_6945() > END_X || prevHeight > motive.method_6943()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = motive.method_6943();
            }
            try {
                this.method_37063((class_364)new PaintingButton(posx, posy, motive.method_6945(), motive.method_6943(), (class_2561)new class_2585(""), button -> {
                    this.sendPacket(motive, this.entityID);
                    this.method_25432();
                    this.method_25419();
                }, motive));
            }
            catch (NullPointerException e) {
                Paintings.LOGGER.warn("*******************");
                Paintings.LOGGER.warn(e.getMessage());
                Paintings.LOGGER.warn("*******************");
            }
            posx += 5 + motive.method_6945();
            ++index;
        }
        this.centerRow(rowstart, this.getRenderablesWithCast().size() - 1);
    }

    private void centerRow(int start, int end) {
        if (this.optionalAbstractWidget(start).isPresent() && this.optionalAbstractWidget(end).isPresent()) {
            int left = this.optionalAbstractWidget((int)start).get().field_22760;
            int right = this.optionalAbstractWidget((int)end).get().field_22760 + this.optionalAbstractWidget(end).get().method_25368();
            int correction = (this.field_22789 - 20 - (right - left)) / 2;
            for (int i = start; i <= end; ++i) {
                this.optionalAbstractWidget(i).ifPresent(widget -> {
                    if (widget instanceof PaintingButton) {
                        PaintingButton painting = (PaintingButton)((Object)widget);
                        painting.shiftX(correction);
                    }
                });
            }
        }
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float f) {
        this.method_25420(stack);
        CommonPaintingScreen.method_25294((class_4587)stack, (int)10, (int)30, (int)(this.field_22789 - 10), (int)(this.field_22790 - 30), (int)0x44444444);
        class_1041 window = this.field_22787.method_22683();
        int scale = (int)window.method_4495();
        RenderSystem.enableScissor((int)(10 * scale), (int)(30 * scale), (int)(this.field_22789 * scale), (int)((this.field_22790 - 60) * scale));
        super.method_25394(stack, mouseX, mouseY, f);
        RenderSystem.disableScissor();
        if (!this.getRenderablesWithCast().isEmpty()) {
            this.drawFakeScrollBar(stack);
        }
        CommonPaintingScreen.method_27534((class_4587)stack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
        this.drawToolTips(stack, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double mouseScroll) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int move = (mouseScroll < 0.0 ? -1 : (mouseScroll > 0.0 ? 1 : 0)) * 16;
            this.movePaintinWidgets(move);
        }
        return super.method_25401(mouseX, mouseY, mouseScroll);
    }

    public boolean method_25403(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            float move = (float)amountY * -1.0f;
            int paintingCanvasTopY = this.optionalFirstWidget().get().field_22761;
            int paintingCanvasBotY = this.optionalLastWidget().get().field_22761 + this.optionalLastWidget().get().method_25364();
            int paintingContainerSize = paintingCanvasBotY - paintingCanvasTopY;
            int viewport = this.field_22790 - 30;
            float portToCanvasScale = (float)viewport / (float)paintingContainerSize;
            float barsize = (float)viewport * portToCanvasScale;
            float scaledViewport = (float)viewport - barsize;
            float usableSpaceScale = (float)paintingContainerSize / scaledViewport;
            float scaledDrageMove = move * usableSpaceScale;
            this.movePaintinWidgets((int)scaledDrageMove);
        }
        return super.method_25403(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void movePaintinWidgets(int scrollAmount) {
        int paintingCanvasTopY = this.optionalFirstWidget().get().field_22761;
        int onScreenTopLimit = 35;
        int paintingCanvasBotY = this.optionalLastWidget().get().field_22761 + this.optionalLastWidget().get().method_25364();
        int onScreenBottomLimit = this.field_22790 - onScreenTopLimit;
        if (scrollAmount > 0 && paintingCanvasTopY < onScreenTopLimit || scrollAmount < 0 && paintingCanvasBotY >= onScreenBottomLimit) {
            this.getRenderablesWithCast().forEach(widget -> ((class_339)widget).field_22761 += scrollAmount);
            this.scrollBarScroll -= scrollAmount;
        }
    }

    private void drawToolTips(class_4587 mat, int mouseX, int mouseY) {
        if (!CommonConfig.show_painting_size) {
            return;
        }
        for (class_4068 guiButton : this.getRenderablesWithCast()) {
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).method_25405(mouseX, mouseY)) continue;
            class_2585 text = new class_2585(button.method_25368() / 16 + "x" + button.method_25364() / 16);
            class_2568 hover = new class_2568(class_2568.class_5247.field_24342, (Object)text);
            class_2583 style = class_2583.field_24360.method_10949(hover);
            this.method_25418(mat, style, this.field_22789 / 2 - this.field_22793.method_1727(text.method_10851()) - 4, this.field_22790 - 7);
        }
    }

    private void drawFakeScrollBar(class_4587 mat) {
        if (this.getRenderablesWithCast().isEmpty()) {
            return;
        }
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int top = this.optionalFirstWidget().get().field_22761;
            int containerSize = this.field_22790 - 60;
            int bot = this.optionalLastWidget().get().field_22761 + this.optionalLastWidget().get().method_25364();
            int totalSize = bot - top;
            float percent = (float)containerSize / (float)totalSize * 100.0f;
            if ((double)percent < 100.0) {
                int sizeBar = (int)((float)containerSize / 100.0f * percent);
                int relativeScroll = (int)((float)this.scrollBarScroll / 100.0f * percent);
                this.method_25296(mat, this.field_22789 - 10, 30, this.field_22789, 30 + containerSize, Integer.MIN_VALUE, -2145246686);
                this.method_25296(mat, this.field_22789 - 10, 30 + relativeScroll, this.field_22789, 30 + relativeScroll + sizeBar, -2130706433, -2145246686);
            }
        }
    }

    private Optional<class_339> optionalFirstWidget() {
        return this.optionalAbstractWidget(0);
    }

    private Optional<class_339> optionalLastWidget() {
        return this.optionalAbstractWidget(this.getRenderablesWithCast().size() - 1);
    }

    @Override
    public Optional<class_339> optionalAbstractWidget(int index) {
        return Optional.empty();
    }

    @Override
    public List<class_4068> getRenderablesWithCast() {
        throw new RuntimeException("painting gui common code crash override. please override paintingscreen");
    }

    @Override
    public void sendPacket(class_1535 motive, int entityID) {
    }
}

